using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace RayGun
{
    /// <summary>
    /// To jest gwny typ dla naszej gry
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        // wiat Gry
        SoundEffect shootSoundEffect;
        SoundEffectInstance shootSoundEffectInstance;

        // Bierzcy stan gamepada podczas metody Update()
        GamePadState pad1;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Pozwala grze wykona dowoln inicjalizacj jakiej potrzebuje przed rozpoczeciem dziaania.
        /// To tutaj moe ona zada potrzebnych usug i zaadowa zwizan zawarto nie graficzn.
        /// Wywoanie base.Initialize wyliczy wszystkie komponenty i take je zainicjuje.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Dodaj w tym miejscu swoj logik inicjalizacji

            base.Initialize();
        }

        /// <summary>
        /// LoadContent bedzie wywoany raz na gr i tu naley adowa
        /// ca zawarto.
        /// </summary>
        protected override void LoadContent()
        {
            // Stwrz nowy SpriteBatch, ktrego mona uzy do rysowania tekstur.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            shootSoundEffect = Content.Load<SoundEffect>("shootSound");

            shootSoundEffectInstance = shootSoundEffect.CreateInstance();
        }

        /// <summary>
        /// UnloadContent bedzie wywoany raz na gr i tu naley usuwa 
        /// ca zawarto.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Usun w tym miejscu kad zawarto nie obsugiwan przez ContentManager
        }

        /// <summary>
        /// Pozwala uruchomi w grze logik, tak jak aktualizacja wiata,
        /// sprawdzenie kolizji, pobranie wejcia i odtwarzanie dwiku.
        /// </summary>
        /// <param name="gameTime">Dostarcza chwilow warto zmiennych czasowych.</param>
        protected override void Update(GameTime gameTime)
        {
            // Pozwala na wyjcie z gry
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            pad1 = GamePad.GetState(PlayerIndex.One);

            if (pad1.Buttons.A == ButtonState.Pressed)
            {
                if (shootSoundEffectInstance.State != SoundState.Playing)
                {
                    shootSoundEffectInstance.Play();
                }
            }
            else
            {
                shootSoundEffectInstance.Stop();
            }

            shootSoundEffectInstance.Pitch = pad1.ThumbSticks.Left.Y;
            shootSoundEffectInstance.Pan = pad1.ThumbSticks.Left.X;

            base.Update(gameTime);
        }

        /// <summary>
        /// Metoda wywoywana kiedy gra powinna si wyswietli.
        /// </summary>
        /// <param name="gameTime">Dostarcza chwilow warto zmiennych czasowych.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            // TODO: Dodaj w tym miejscu kod wyswietlajcy

            base.Draw(gameTime);
        }
    }
}
